/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.waypoint;

import com.google.common.io.Files;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import journeymap.client.io.FileHandler;
import journeymap.common.Journeymap;
import journeymap.common.codecs.WaypointCodecs;
import journeymap.common.codecs.WaypointGroupCodecs;
import journeymap.common.nbt.waypoint.WaypointDAO;
import journeymap.common.waypoint.WaypointGroupImpl;
import journeymap.common.waypoint.WaypointImpl;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2509;
import net.minecraft.class_2520;

public class ClientWaypointDAO
extends WaypointDAO {
    protected static final String DAT_FILE = "WaypointData.dat";
    protected static final String TMP_FILE = "WaypointData_tmp.dat";
    protected static final String BACKUP_PREFIX = "WaypointData_backup_";
    protected static final String BACKUP_SUFFIX = ".dat";
    protected static final int MAX_BACKUPS = 10;
    protected static final String MERGED_DIR = "merged";
    protected static final long BACKUP_INTERVAL_MS = 900000L;
    private static final DateTimeFormatter BACKUP_DATE_FORMAT = DateTimeFormatter.ofPattern("MM-dd-yyyy_HH-mm-ss");
    private final ReentrantLock writeLock = new ReentrantLock();
    private long lastBackupTime = 0L;

    public ClientWaypointDAO() {
        this.data = this.load();
        this.mergeExternalDatFiles();
    }

    @Override
    public Map<String, WaypointGroupImpl> decodeGroups(class_2487 data) {
        LinkedHashMap<String, WaypointGroupImpl> groups = new LinkedHashMap<String, WaypointGroupImpl>();
        if (data.method_10545("groups")) {
            class_2487 groupsTags = (class_2487)data.method_10562("groups").get();
            for (String key : groupsTags.method_10541()) {
                class_2520 tag = groupsTags.method_10580(key);
                DataResult result = WaypointGroupCodecs.V1_WAYPOINT_GROUP_CODEC.parse((DynamicOps)class_2509.field_11560, (Object)tag);
                if (!result.result().isPresent()) continue;
                WaypointGroupImpl group = (WaypointGroupImpl)result.result().get();
                groups.put(group.getGuid(), group);
            }
        }
        return groups;
    }

    @Override
    public class_2487 encodeGroups(Collection<WaypointGroupImpl> groups) {
        class_2487 tag = new class_2487();
        tag.method_10566("groups", (class_2520)new class_2487());
        class_2487 groupsTag = (class_2487)tag.method_10562("groups").get();
        for (WaypointGroupImpl group : groups) {
            DataResult result = WaypointGroupCodecs.V1_WAYPOINT_GROUP_CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)group);
            if (!result.result().isPresent()) continue;
            groupsTag.method_10566(group.getGuid(), (class_2520)result.result().get());
        }
        return tag;
    }

    @Override
    public Map<String, WaypointImpl> decodeWaypoints(class_2487 data) {
        LinkedHashMap<String, WaypointImpl> waypoints = new LinkedHashMap<String, WaypointImpl>();
        if (data.method_10545("waypoints")) {
            class_2487 groupsTags = (class_2487)data.method_10562("waypoints").get();
            for (String key : groupsTags.method_10541()) {
                class_2520 tag = groupsTags.method_10580(key);
                WaypointImpl waypoint = this.decodeWaypoint(tag);
                if (waypoint == null) continue;
                waypoints.put(waypoint.getGuid(), waypoint);
            }
        }
        return waypoints;
    }

    @Override
    public class_2487 encodeWaypoints(Collection<WaypointImpl> waypoints) {
        class_2487 tag = new class_2487();
        tag.method_10566("waypoints", (class_2520)new class_2487());
        class_2487 wpTag = (class_2487)tag.method_10562("waypoints").get();
        for (WaypointImpl wp : waypoints) {
            class_2520 result = this.encodeWaypoint(wp);
            if (result == null) continue;
            wpTag.method_10566(wp.getGuid(), result);
        }
        return tag;
    }

    @Override
    public WaypointImpl decodeWaypoint(class_2520 data) {
        DataResult result = WaypointCodecs.V1_WAYPOINT_CODEC.parse((DynamicOps)class_2509.field_11560, (Object)data);
        if (result.result().isPresent()) {
            return (WaypointImpl)result.result().get();
        }
        return null;
    }

    @Override
    public class_2520 encodeWaypoint(WaypointImpl waypoint) {
        DataResult result = WaypointCodecs.V1_WAYPOINT_CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)waypoint);
        if (result.result().isPresent()) {
            return (class_2520)result.result().get();
        }
        return null;
    }

    @Override
    public WaypointImpl copyWaypoint(WaypointImpl waypoint) {
        class_2520 rawCopy = this.encodeWaypoint(waypoint);
        if (rawCopy != null) {
            return this.decodeWaypoint(rawCopy);
        }
        return null;
    }

    private void mergeExternalDatFiles() {
        File[] externalFiles = this.findExternalDatFiles();
        if (externalFiles == null || externalFiles.length == 0) {
            return;
        }
        Journeymap.getLogger().info("Found {} external .dat file(s) to process for merge.", (Object)externalFiles.length);
        for (File file : externalFiles) {
            class_2487 externalData = this.validateExternalDat(file);
            if (externalData == null) {
                Journeymap.getLogger().warn("Skipping invalid external dat file: {}", (Object)file.getName());
                continue;
            }
            int mergedCount = this.mergeExternalData(externalData);
            Journeymap.getLogger().info("Merged {} new entries from {}.", (Object)mergedCount, (Object)file.getName());
            this.moveToMergedDir(file);
        }
    }

    private File[] findExternalDatFiles() {
        File waypointDir = FileHandler.getWaypointDir();
        return waypointDir.listFiles((dir, name) -> name.endsWith(BACKUP_SUFFIX) && !name.equals(DAT_FILE) && !name.equals(TMP_FILE));
    }

    private class_2487 validateExternalDat(File file) {
        try {
            class_2487 externalData = class_2507.method_10633((Path)file.toPath());
            if (externalData == null) {
                Journeymap.getLogger().warn("External dat file {} is empty or unreadable.", (Object)file.getName());
                return null;
            }
            boolean hasGroups = externalData.method_10545("groups");
            boolean hasWaypoints = externalData.method_10545("waypoints");
            if (!hasGroups && !hasWaypoints) {
                Journeymap.getLogger().warn("External dat file {} does not contain groups or waypoints, skipping.", (Object)file.getName());
                return null;
            }
            return externalData;
        }
        catch (Exception e) {
            Journeymap.getLogger().warn("Failed to validate external dat file {}: {}", (Object)file.getName(), (Object)e.getMessage());
            return null;
        }
    }

    private int mergeExternalData(class_2487 externalData) {
        int mergedCount = 0;
        Map<String, WaypointGroupImpl> externalGroups = this.decodeGroups(externalData);
        for (WaypointGroupImpl group : externalGroups.values()) {
            if (this.guidExistsInGroups(group.getGuid())) continue;
            this.addGroup(group);
            ++mergedCount;
        }
        Map<String, WaypointImpl> externalWaypoints = this.decodeWaypoints(externalData);
        for (WaypointImpl waypoint : externalWaypoints.values()) {
            if (this.guidExistsInWaypoints(waypoint.getGuid())) continue;
            this.addWaypoint(waypoint);
            ++mergedCount;
        }
        return mergedCount;
    }

    private boolean guidExistsInGroups(String guid) {
        if (!this.data.method_10545("groups")) {
            return false;
        }
        return ((class_2487)this.data.method_10562("groups").get()).method_10545(guid);
    }

    private boolean guidExistsInWaypoints(String guid) {
        if (!this.data.method_10545("waypoints")) {
            return false;
        }
        return ((class_2487)this.data.method_10562("waypoints").get()).method_10545(guid);
    }

    private void moveToMergedDir(File file) {
        try {
            File destination;
            File mergedDir = new File(FileHandler.getWaypointDir(), MERGED_DIR);
            if (!mergedDir.exists()) {
                mergedDir.mkdirs();
            }
            if ((destination = new File(mergedDir, file.getName())).exists()) {
                String timestamp = LocalDateTime.now().format(BACKUP_DATE_FORMAT);
                String baseName = file.getName().replace(BACKUP_SUFFIX, "");
                destination = new File(mergedDir, baseName + "_" + timestamp + BACKUP_SUFFIX);
            }
            Files.copy((File)file, (File)destination);
            if (!file.delete()) {
                Journeymap.getLogger().warn("Failed to delete merged file {}, it may be processed again.", (Object)file.getName());
            }
        }
        catch (Exception e) {
            Journeymap.getLogger().warn("Failed to move merged file {} to {}: {}", (Object)file.getName(), (Object)MERGED_DIR, (Object)e.getMessage());
        }
    }

    private File getFile() {
        return new File(FileHandler.getWaypointDir(), DAT_FILE);
    }

    private void write(File path) {
        this.writeLock.lock();
        try (FileOutputStream fos = new FileOutputStream(path);
             DataOutputStream outputStream = new DataOutputStream(fos);){
            class_2507.method_10628((class_2487)this.data, (DataOutput)outputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private boolean verify(File file) {
        try {
            class_2507.method_10633((Path)file.toPath());
            return true;
        }
        catch (Exception e) {
            Journeymap.getLogger().error("Verification failed for {}: {}", (Object)file, (Object)e.getMessage());
            return false;
        }
    }

    @Override
    public void save(boolean async) {
        if (this.isDirty()) {
            File tmpFile = new File(FileHandler.getWaypointDir(), TMP_FILE);
            File datFile = this.getFile();
            this.write(tmpFile);
            if (!this.verify(tmpFile)) {
                Journeymap.getLogger().error("Waypoint temp file failed verification, aborting save.");
                tmpFile.delete();
                return;
            }
            if (datFile.exists()) {
                long now = System.currentTimeMillis();
                if (now - this.lastBackupTime >= 900000L) {
                    this.backup(new File(FileHandler.getWaypointDir(), "backup"), datFile);
                    this.lastBackupTime = now;
                }
                if (!datFile.delete()) {
                    Journeymap.getLogger().error("Failed to delete existing {} before rename.", (Object)DAT_FILE);
                    tmpFile.delete();
                    return;
                }
            }
            if (!tmpFile.renameTo(datFile)) {
                Journeymap.getLogger().error("Failed to rename {} to {}.", (Object)TMP_FILE, (Object)DAT_FILE);
                return;
            }
            this.setDirty(false);
        }
    }

    @Override
    public Map<String, WaypointGroupImpl> getGroups() {
        return this.decodeGroups(this.data);
    }

    @Override
    public Map<String, WaypointImpl> getWaypoints() {
        return this.decodeWaypoints(this.data);
    }

    private class_2487 load() {
        try {
            if (this.getFile().exists()) {
                return class_2507.method_10633((Path)this.getFile().toPath());
            }
            return new class_2487();
        }
        catch (Exception e) {
            Journeymap.getLogger().error("WaypointData.dat file is corrupted. Deleting as it is unusable.", (Throwable)e);
            if (this.getFile().exists()) {
                File corrupted = new File(FileHandler.getWaypointDir(), "corrupted");
                this.backup(corrupted, this.getFile());
                this.getFile().delete();
            }
            if (ClientWaypointDAO.restore(new File(FileHandler.getWaypointDir(), "backup"), FileHandler.getWaypointDir(), DAT_FILE)) {
                return this.loadRestored();
            }
            return new class_2487();
        }
    }

    private class_2487 loadRestored() {
        try {
            if (this.getFile().exists()) {
                return class_2507.method_10633((Path)this.getFile().toPath());
            }
        }
        catch (Exception e) {
            Journeymap.getLogger().error("Restored backup is also corrupted: {}", (Object)e.getMessage());
        }
        return new class_2487();
    }

    private static boolean restore(File backupDir, File dir, String fileName) {
        try {
            File[] backups = backupDir.listFiles((d, name) -> name.startsWith(BACKUP_PREFIX) && name.endsWith(BACKUP_SUFFIX));
            if (backups == null || backups.length == 0) {
                Journeymap.getLogger().error("No backup files found in {}", (Object)backupDir);
                return false;
            }
            Arrays.sort(backups, Comparator.comparingLong(File::lastModified).reversed());
            for (File backupFile : backups) {
                Journeymap.getLogger().info("Attempting to restore from backup: {}", (Object)backupFile.getName());
                try {
                    File target = new File(dir, fileName);
                    Files.copy((File)backupFile, (File)target);
                    return true;
                }
                catch (Exception e) {
                    Journeymap.getLogger().error("Failed to restore from {}, trying next backup: {}", (Object)backupFile.getName(), (Object)e.getMessage());
                }
            }
        }
        catch (Exception e) {
            Journeymap.getLogger().error("Can't restore from backup dir {}: {}", (Object)backupDir, (Object)e);
        }
        return false;
    }

    private void backup(File backupDir, File oldFile) {
        try {
            if (!backupDir.exists()) {
                backupDir.mkdirs();
            }
            String timestamp = LocalDateTime.now().format(BACKUP_DATE_FORMAT);
            File tmpBackup = new File(backupDir, TMP_FILE);
            File backupFile = new File(backupDir, BACKUP_PREFIX + timestamp + BACKUP_SUFFIX);
            Files.copy((File)oldFile, (File)tmpBackup);
            if (!this.verify(tmpBackup)) {
                Journeymap.getLogger().error("Backup verification failed, aborting backup.");
                tmpBackup.delete();
                return;
            }
            if (!tmpBackup.renameTo(backupFile)) {
                Journeymap.getLogger().error("Failed to rename tmp backup to {}", (Object)backupFile.getName());
                tmpBackup.delete();
                return;
            }
            ClientWaypointDAO.pruneBackups(backupDir);
        }
        catch (Exception e) {
            Journeymap.getLogger().error("Can't backup file {}: {}", (Object)oldFile, (Object)e);
        }
    }

    private static void pruneBackups(File backupDir) {
        File[] backups = backupDir.listFiles((dir, name) -> name.startsWith(BACKUP_PREFIX) && name.endsWith(BACKUP_SUFFIX));
        if (backups == null || backups.length <= 10) {
            return;
        }
        Arrays.sort(backups, Comparator.comparingLong(File::lastModified));
        int toDelete = backups.length - 10;
        for (int i = 0; i < toDelete; ++i) {
            if (backups[i].delete()) continue;
            Journeymap.getLogger().warn("Failed to delete old backup: {}", (Object)backups[i]);
        }
    }
}

